--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A mobile object for a creature, NPC, or the player.
--- @class tes3mobileActor : tes3mobileObject
--- @field actionBeforeCombat tes3actionData *Read-only*. Action data stored before the actor entered combat.
--- @field actionData tes3actionData *Read-only*. Current action data. Pre-combat action data is stored in the `actionBeforeCombat` property.
--- @field activeAI boolean Friendly access to the actor's flag that controls if AI is active.
--- @field activeMagicEffectList tes3activeMagicEffect[] *Read-only*. The active magic effects on the actor, from which all others can be accessed. A table with [`tes3activeMagicEffect`](https://mwse.github.io/MWSE/types/tes3activeMagicEffect/) items.
--- @field actorType tes3.actorType *Read-only*. The type of the mobile actor. Maps to values in [`tes3.actorType`](https://mwse.github.io/MWSE/references/actor-types/) namespace.
--- @field agility tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's agility attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- @field aiPlanner tes3aiPlanner|nil *Read-only*. Access to the mobile's AI planner and AI package information. Doesn't exist on the player mobile.
--- @field alarm number The actor's alarm AI value.
--- @field animationController tes3actorAnimationController|tes3playerAnimationController *Read-only*. No description yet available.
--- @field armorRating number *Read-only*. The actor's current armour rating, taking equipment condition into account. Armour mitigation can be automatically applied to damage by using the `applyDamage` function.
--- 
--- !!! note "Armour mitigation calculation:"
--- 	```
--- 	x = damage / (damage + target.armorRating)
--- 
--- 	damage *= max(fCombatArmorMinMult, x)
--- 
--- 	if damage < 1 then
--- 
--- 		damage = 1
--- 
--- 	end
--- 	```
--- 
--- @field attackBonus number Direct access to the actor's attack bonus effect attribute.
--- @field attacked boolean *Read-only*. Friendly access to the actor's flag that controls if the actor has been attacked.
--- @field attributes tes3statistic[]|tes3statisticSkill[] *Read-only*. Access to a table of 8 [`tes3statistic`](https://mwse.github.io/MWSE/types/tes3statistic/) objects for the actor's attributes. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- 
--- !!! note
--- 	This array is 1-indexed. The array indices correspond to the [tes3.attribute](https://mwse.github.io/MWSE/references/attributes/) table plus 1 to account for Lua's 1-based array indexing. In other words `myMobile.attributes[tes3.attribute.strength + 1]` returns the `tes3statistic` object corresponding to strength.
--- @field barterGold number The current amount of gold that the actor has access to for bartering.
--- 
--- Barter gold is reset on talking to an actor if fBarterGoldResetDelay hours have passed since the last transaction. The base value is held in `tes3npc.barterGold`, which is the base object and not an instance.
--- @field blind number Direct access to the actor's blind effect attribute.
--- @field canAct boolean *Read-only*. If `true`, the actor is able to freely execute actions like attacking or casting magic. This is equal to checking if the actor is not dead, knocked down, knocked out, hit stunned, paralyzed, drawing/sheathing their weapon, attacking, casting magic or using a lockpick or probe.
--- @field canJump boolean *Read-only*. If `true`, the actor is currently able to jump. This is equal to checking if the actor is not dead, knocked down, knocked out, paralyzed, jumping, falling, swimming or flying.
--- @field canJumpMidair boolean *Read-only*. If `true`, the actor is currently able to jump midair. This is equal to checking if the actor is not dead, knocked down, knocked out, paralyzed, swimming or flying. For more information on midair jumping see [`tes3mobileActor:doJump()`](https://mwse.github.io/MWSE/types/tes3mobileActor/#dojump).
--- @field canMove boolean *Read-only*. If `true`, the actor is able to freely move along the ground or in the air. This does not include jumping (see `canJump`). This is equal to checking if the actor is not dead, knocked down, knocked out, hit stunned, or paralyzed.
--- @field cell tes3cell *Read-only*. Fetches the cell that the actor is in.
--- @field chameleon number Direct access to the actor's chameleon effect attribute.
--- @field collidingReference tes3reference|nil *Read-only*. The reference that the mobile has collided with this frame. Doesn't include actors and terrain.
--- @field combatSession tes3combatSession|nil *Read-only*. Combat session data. This exists while the actor is in combat to provide memory for AI combat decisions. Doesn't exist on the player's mobile.
--- @field corpseHourstamp number This is the time measured in hours from the beginning of the game when the actor died. Returns a UNIX-style timestamp based on in-world simulation time since the start of the era. For living actors this field has value a of `0`.
--- @field currentEnchantedItem tes3equipmentStack|nil *Read-only*. The currently equipped enchanted item that the actor will use.
--- @field currentSpell tes3spell|tes3enchantment *Read-only*. The currently equipped spell that the actor will use.
--- @field effectAttributes number[] *Read-only*. Access to a table of 24 numbers for the actor's effect attributes. In order those are: `attackBonus`, `sanctuary`, `resistMagicka`, `resistFire`, `resistFrost`, `resistShock`, `resistCommonDisease`, `resistBlightDisease`, `resistCorprus`, `resistPoison`, `resistParalysis`, `chameleon`, `resistNormalWeapons`, `waterBreathing`, `waterWalking`, `swiftSwim`, `jump`, `levitate`, `shield`, `sound`, `silence`, `blind`, `paralyze`, and `invisibility`. Each of those can be accessed individually. For example, `tes3mobileActor.chameleon`.
--- @field encumbrance tes3statistic|tes3statisticSkill *Read-only*. Access to the actor's encumbrance statistic. When modifying this value, prefer to use `tes3.modStatistic` or `tes3.setStatistic` to also update the UI immediately.
--- @field endurance tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's endurance attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- @field facing number *Read-only*. The facing of the actor, in radians. Facing is defined like a compass heading, positive values are clockwise and North (+Y axis) is zero, while facing of PI corresponds to South (-Y axis).
--- 
--- It's the same as `mobile.reference.orientation.z`.
--- @field fatigue tes3statistic|tes3statisticSkill *Read-only*. Access to the actor's fatigue statistic. When modifying this value, prefer to use `tes3.modStatistic` or `tes3.setStatistic` to also update the UI immediately.
--- @field fight number The actor's fight AI value.
--- @field flee number The actor's flee AI value.
--- @field friendlyActors tes3mobileActor[]|tes3mobileCreature[]|tes3mobileNPC[]|tes3mobilePlayer[] *Read-only*. A collection of other `tes3mobileActor`s that this actor considers friendly.
--- @field friendlyFireHitCount number The number of times the player has hit this actor with friendly fire. The actor will turn on the player on the fourth hit if it is not already in combat. The game will not increase this past 4, and will reset it to 0 at the end of combat.
--- @field greetDuration number No description yet available.
--- @field greetTimer number *Read-only*. No description yet available.
--- @field hasBlightDisease boolean *Read-only*. True if the actor is has a blight disease effect. This does not include common or corprus diseases, nor does it include vampirism.
--- @field hasCommonDisease boolean *Read-only*. True if the actor is has a common disease effect. This does not include blight or corprus diseases, nor does it include vampirism.
--- @field hasCorprusDisease boolean *Read-only*. True if the actor is has a corprus disease effect. This does not include common or blight diseases, nor does it include vampirism.
--- @field hasFreeAction boolean *Read-only*. If true, the actor isn't knocked down or knocked out.
--- @field hasVampirism boolean *Read-only*. True if the actor has a vampirism effect. Checks if the actor has an active vampirism magic effect. This is the same method used in the engine to determine if an NPC has a vampire head model, or can use a vampire dialogue response.
--- @field health tes3statistic|tes3statisticSkill *Read-only*. Access to the actor's health statistic. When modifying this value, prefer to use `tes3.modStatistic` or `tes3.setStatistic` to also update the UI immediately.
--- @field height number The height of the mobile's bounding box.
--- @field hello number The actor's hello AI value.
--- @field holdBreathTime number This is the time the actor can stay underwater without taking drowning damage, measured in seconds. It's starting value is `fHoldBreathTime`(GMST) seconds by default. Once the actor is underwater, this value is decreasing based on the time passed while underwater. The actor will start taking drowning damage once this time is below 0. During drowning this time will have more and more negative values based on the duration of the drowning. Changing this allows manipulating for how long the actor can stay underwater without drowning. Note that player's Breath HUD element won't show values larger than `fHoldBreathTime`.
--- @field hostileActors tes3mobileActor[]|tes3mobileCreature[]|tes3mobileNPC[]|tes3mobilePlayer[] *Read-only*. A collection of other `tes3mobileActor`s that this actor considers hostile.
--- @field idleAnim boolean *Read-only*. Friendly access to the actor's flag that controls if the actor is using their idle animation.
--- @field inCombat boolean *Read-only*. Friendly access to the actor's flag that controls if the actor is in combat.
--- @field intelligence tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's intelligence attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- @field invisibility number Direct access to the actor's invisibility effect attribute.
--- @field isAttackingOrCasting boolean *Read-only*. If `true`, the actor is attacking, casting magic or using a lockpick or probe.
--- @field isCrittable boolean *Read-only*. Friendly access to the actor's flag that controls if the actor can be critically hit.
--- @field isDead boolean *Read-only*. True if the actor is dead.
--- @field isDiseased boolean *Read-only*. True if the actor is has a disease effect. This counts normal, blight, and corprus effects.
--- @field isFalling boolean Direct access to the actor's current movement flags, showing if the actor is falling. This is when the actor is falling without having jumped, e.g. if they walked off a ledge.
--- @field isFlying boolean Direct access to the actor's current movement flags, showing if the actor is flying.
--- @field isHitStunned boolean *Read-only*. If `true`, the actor is affected by hit stun. This prevents the actor from initiating an attack, but not continuing and finishing an attack. It also prevents movement except for jumping.
--- @field isJumping boolean Direct access to the actor's current movement flags, showing if the actor is jumping.
--- @field isKnockedDown boolean *Read-only*. If `true`, the actor is knocked down. An actor can be knocked down after being attacked or falling.
--- @field isKnockedOut boolean *Read-only*. If `true`, the actor is knocked out. An actor can be knocked out if their fatigue has been reduced below zero.
--- @field isMovingBack boolean Direct access to the actor's current movement flags, showing if the actor is moving backwards.
--- @field isMovingForward boolean Direct access to the actor's current movement flags, showing if the actor is moving forwards.
--- @field isMovingLeft boolean Direct access to the actor's current movement flags, showing if the actor is moving left.
--- @field isMovingRight boolean Direct access to the actor's current movement flags, showing if the actor is moving right.
--- @field isParalyzed boolean *Read-only*. If `true`, the actor is affected by the magic effect paralyze.
--- @field isPlayerDetected boolean Direct access to the actor's flag showing the player was detected on the last detection check.
--- @field isPlayerHidden boolean Direct access to the actor's flag showing the player was hidden on the last detection check.
--- @field isReadyingWeapon boolean *Read-only*. If `true`, the actor is drawing or sheathing their weapon.
--- @field isRunning boolean Direct access to the actor's current movement flags, showing if the actor is running.
--- @field isSliding boolean Direct access to the actor's current movement flags, showing if the actor is sliding off a steep surface.
--- @field isSneaking boolean Direct access to the actor's current movement flags, showing if the actor is sneaking.
--- @field isSpeaking boolean *Read-only*. This property is `true` when the actor is speaking a dialogue line. This includes: hit grunts, combat reactions, and the usual dialogue.
--- @field isSwimming boolean Direct access to the actor's current movement flags, showing if the actor is swimming.
--- @field isTurningLeft boolean Direct access to the actor's current movement flags, showing if the actor is turning left.
--- @field isTurningRight boolean Direct access to the actor's current movement flags, showing if the actor is turning right.
--- @field isWalking boolean Direct access to the actor's current movement flags, showing if the actor is walking.
--- @field jump number Direct access to the actor's jump effect attribute.
--- @field lastGroundZ number This has a large negative value if the actor is on the ground. When the actor jumps, this will have a positive value. During `jump` event this value is still negative. A split second after, it will have the value of the `.z` coordinate when the actor was on the ground. Beware that this value changes after some amount of time while the actors is in the air.
--- @field levitate number Direct access to the actor's levitate effect attribute.
--- @field luck tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's luck attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- @field magicka tes3statistic|tes3statisticSkill *Read-only*. Access to the actor's magicka statistic. When modifying this value, prefer to use `tes3.modStatistic` or `tes3.setStatistic` to also update the UI immediately.
--- @field magickaMultiplier tes3statistic|tes3statisticSkill *Read-only*. Access to the actor's magicka multiplier statistic.
--- @field nextActionWeight number *Read-only*. No description yet available.
--- @field paralyze number Direct access to the actor's paralyze effect attribute.
--- @field personality tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's personality attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- @field readiedAmmo tes3equipmentStack|nil The currently equipped ammo, if any.
--- @field readiedAmmoCount integer The number of ammo equipped for the readied ammo.
--- @field readiedShield tes3equipmentStack|nil The currently equipped shield, if any.
--- @field readiedWeapon tes3equipmentStack|nil The currently equipped weapon, if any.
--- @field resistBlightDisease number Direct access to the actor's blight disease resistance effect attribute.
--- @field resistCommonDisease number Direct access to the actor's common disease resistance effect attribute.
--- @field resistCorprus number Direct access to the actor's corprus disease resistance effect attribute.
--- @field resistFire number Direct access to the actor's fire resistance effect attribute.
--- @field resistFrost number Direct access to the actor's frost resistance effect attribute.
--- @field resistMagicka number Direct access to the actor's magicka resistance effect attribute.
--- @field resistNormalWeapons number Direct access to the actor's normal weapon resistance effect attribute.
--- @field resistParalysis number Direct access to the actor's paralysis resistance effect attribute.
--- @field resistPoison number Direct access to the actor's poison resistance effect attribute.
--- @field resistShock number Direct access to the actor's shock resistance effect attribute.
--- @field sanctuary number Direct access to the actor's sanctuary effect attribute.
--- @field scanInterval number The time interval in seconds between specific actor AI checks. These checks include checking for hostile actors and engaging combat, as well as checking if the actor should equip a light source if it is too dark. The specified time in seconds will always be increased by one second when checking, therefore a value of `0.0` will actually cause the actor AI checks to occur every second instead of every frame. Setting this to lower values than the default increases the impact on performance. The default value for a newly created actor depends on the total amount of all currently active [`tes3aiPlanner`](https://mwse.github.io/MWSE/types/tes3aiPlanner), meaning the checks will be executed at different intervals for each actor.
--- @field scanTimer number *Read-only*. The time in seconds since the last time the checks specified in [`scanInterval`](https://mwse.github.io/MWSE/types/tes3mobileActor/#scaninterval) were executed.
--- @field shield number Direct access to the actor's shield effect attribute.
--- @field silence number Direct access to the actor's silence effect attribute.
--- @field sound number Direct access to the actor's sound effect attribute.
--- @field speed tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's speed attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- @field spellReadied boolean Friendly access to the actor's flag that controls if the actor has a spell readied.
--- @field strength tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's strength attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
--- @field swiftSwim number Direct access to the actor's swift swim effect attribute.
--- @field talkedTo boolean Direct access to the actor's flag that shows it was recently talked to.
--- @field torchSlot tes3equipmentStack The currently equipped light.
--- @field underwater boolean *Read-only*. Friendly access to the actor's flag that controls if the actor is under water.
--- @field waterBreathing number Direct access to the actor's water breathing effect attribute.
--- @field waterWalking number Direct access to the actor's water walking effect attribute.
--- @field weaponDrawn boolean *Read-only*. Friendly access to the actor's flag that shows if the weapon model is visible. When readying a weapon, there is a short period of time at the start of the animation, where the weapon is not visible yet. This flag will only be set after this initial stage is done. This flag is still set with hand-to-hand even though it doesn't use a model. Setting this to false while a weapon is drawn will normally cause the actor to play its weapon draw animation again.
--- @field weaponReady boolean A flag for if the actor has a weapon ready or being readied (visible and held in the hand). Setting it to true will cause the actor to take out their weapon. Setting it to false will cause the actor to put it away.
--- @field werewolf boolean *Read-only*. Friendly access to the actor's flag that controls if the actor is in werewolf form.
--- @field width number *Read-only*. No description yet available.
--- @field willpower tes3statistic|tes3statisticSkill *Read-only*. Direct access to the actor's willpower attribute statistic. If you are setting player stats, instead use `tes3.setStatistic` to also update the UI immediately.
tes3mobileActor = {}

--- Damages the actor, with options to control mitigation and difficulty scaling. Invokes the [`damage`](https://mwse.github.io/MWSE/events/damage/) and [`damaged`](https://mwse.github.io/MWSE/events/damaged/) events, with `tes3.damageSource.script` source. Returns the actual damage done after armor mitigation and resistance, but before difficulty scaling.
--- @param params tes3mobileActor.applyDamage.params This table accepts the following values:
--- 
--- `damage`: number — The amount of damage to apply.
--- 
--- `applyArmor?`: boolean — *Default*: `false`. If armor should mitigate the incoming damage. If the player is the target, armor experience will be gained.
--- 
--- `resistAttribute?`: tes3.effectAttribute — *Optional*. The resistance attribute that is applied to the damage. It can reduce damage or exploit weakness. Uses values from [`tes3.effectAttribute`](https://mwse.github.io/MWSE/references/effect-attributes/) namespace.
--- 
--- `applyDifficulty?`: boolean — *Default*: `false`. If the game difficulty modifier should be applied. Must be used with the `playerAttack` argument to apply the correct modifier.
--- 
--- `playerAttack?`: boolean — *Optional*. If the attack came from the player. Used for difficulty calculation.
--- 
--- `doNotChangeHealth?`: boolean — *Default*: `false`. If all armor effects except the health change should be applied. These include hit sounds, armor condition damage, and player experience gain from being hit.
--- @return number result No description yet available.
function tes3mobileActor:applyDamage(params) end

---Table parameter definitions for `tes3mobileActor.applyDamage`.
--- @class tes3mobileActor.applyDamage.params
--- @field damage number The amount of damage to apply.
--- @field applyArmor? boolean *Default*: `false`. If armor should mitigate the incoming damage. If the player is the target, armor experience will be gained.
--- @field resistAttribute? tes3.effectAttribute *Optional*. The resistance attribute that is applied to the damage. It can reduce damage or exploit weakness. Uses values from [`tes3.effectAttribute`](https://mwse.github.io/MWSE/references/effect-attributes/) namespace.
--- @field applyDifficulty? boolean *Default*: `false`. If the game difficulty modifier should be applied. Must be used with the `playerAttack` argument to apply the correct modifier.
--- @field playerAttack? boolean *Optional*. If the attack came from the player. Used for difficulty calculation.
--- @field doNotChangeHealth? boolean *Default*: `false`. If all armor effects except the health change should be applied. These include hit sounds, armor condition damage, and player experience gain from being hit.

--- Damages the actor's fatigue, with accompanying reaction from the reciever. Invokes the [`damageHandToHand`](https://mwse.github.io/MWSE/events/damageHandToHand/) and [`damagedHandToHand`](https://mwse.github.io/MWSE/events/damagedHandToHand/) events, with `tes3.damageSource.script` source. Returns the actual fatigue damage done.
--- @param fatigueDamage number The amount of fatigue damage to apply.
--- @param swing? number *Optional*. The attack swing magnitude, range 0-1. Only modifies hit volume.
--- @param alwaysPlayHitVoice? boolean *Optional*. Always play the hit reaction voiceover.
--- @return number result No description yet available.
function tes3mobileActor:applyFatigueDamage(fatigueDamage, swing, alwaysPlayHitVoice) end

--- **Deprecated, please use [`applyDamage()`](https://mwse.github.io/MWSE/types/tes3mobileActor/#applydamage) instead.**
--- 
--- Damages the actor.
--- @deprecated
--- @param damage number The amount of damage to apply.
--- @param isPlayerAttack? boolean *Default*: `false`. Used to calculate difficulty scaling.
--- @param scaleWithDifficulty? boolean *Optional*. Apply difficulty scaling to the damage.
--- @param doNotChangeHealth? boolean *Default*: `false`. Do all the audiovisual effects of damage without the health change.
--- @return boolean result No description yet available.
function tes3mobileActor:applyHealthDamage(damage, isPlayerAttack, scaleWithDifficulty, doNotChangeHealth) end

--- Reduces the actor's current fatigue by the amount a regular jump would currently cost.
function tes3mobileActor:applyJumpFatigueCost() end

--- Calculates the damage that would be inflicted to an actor after armor and/or resistance. Returns the actual damage done after armor mitigation and resistance, but before difficulty scaling.
--- @param params tes3mobileActor.calcEffectiveDamage.params This table accepts the following values:
--- 
--- `damage`: number — The amount of damage to apply.
--- 
--- `applyArmor?`: boolean — *Default*: `false`. If armor should mitigate the incoming damage.
--- 
--- `resistAttribute?`: tes3.effectAttribute — *Optional*. The resistance attribute that is applied to the damage. It can reduce damage or exploit weakness. Uses values from [`tes3.effectAttribute`](https://mwse.github.io/MWSE/references/effect-attributes/) namespace.
--- @return number result No description yet available.
function tes3mobileActor:calcEffectiveDamage(params) end

---Table parameter definitions for `tes3mobileActor.calcEffectiveDamage`.
--- @class tes3mobileActor.calcEffectiveDamage.params
--- @field damage number The amount of damage to apply.
--- @field applyArmor? boolean *Default*: `false`. If armor should mitigate the incoming damage.
--- @field resistAttribute? tes3.effectAttribute *Optional*. The resistance attribute that is applied to the damage. It can reduce damage or exploit weakness. Uses values from [`tes3.effectAttribute`](https://mwse.github.io/MWSE/references/effect-attributes/) namespace.

--- Calculates the starting velocity of a jump.
--- @param params? tes3mobileActor.calculateJumpVelocity.params This table accepts the following values:
--- 
--- `direction?`: tes3vector2 — *Optional*. The ground direction vector used to calculate the velocity. If not specified, a zero-length direction vector for a regular jump without movement will be used.
--- @return tes3vector3 result No description yet available.
function tes3mobileActor:calculateJumpVelocity(params) end

---Table parameter definitions for `tes3mobileActor.calculateJumpVelocity`.
--- @class tes3mobileActor.calculateJumpVelocity.params
--- @field direction? tes3vector2 *Optional*. The ground direction vector used to calculate the velocity. If not specified, a zero-length direction vector for a regular jump without movement will be used.

--- Forces the actor to jump. If `velocity` or other parameters with non-default values are specified it will be treated as a non-default jump during the [`jump`](https://mwse.github.io/MWSE/events/jump) event. Returns `false` if the actor is currently unable to jump or the jump has been cancelled, otherwise returns `true`.
--- @param params? tes3mobileActor.doJump.params This table accepts the following values:
--- 
--- `velocity?`: tes3vector3 — *Optional*. The initial velocity of the jump. If not specified, the velocity of a regular jump without movement will be used.
--- 
--- `applyFatigueCost?`: boolean — *Default*: `true`. If `true`, reduces the actor's current fatigue by the amount a regular jump would currently cost. Will not reduce fatigue if `false`.
--- 
--- `allowMidairJumping?`: boolean — *Default*: `false`. If `true`, enables the jump to be performed while already jumping or falling. Does not work during levitation or other methods of flying.
--- @return boolean result No description yet available.
function tes3mobileActor:doJump(params) end

---Table parameter definitions for `tes3mobileActor.doJump`.
--- @class tes3mobileActor.doJump.params
--- @field velocity? tes3vector3 *Optional*. The initial velocity of the jump. If not specified, the velocity of a regular jump without movement will be used.
--- @field applyFatigueCost? boolean *Default*: `true`. If `true`, reduces the actor's current fatigue by the amount a regular jump would currently cost. Will not reduce fatigue if `false`.
--- @field allowMidairJumping? boolean *Default*: `false`. If `true`, enables the jump to be performed while already jumping or falling. Does not work during levitation or other methods of flying.

--- Equips an item, optionally adding the item if needed. If the best match is already equipped, it does not perform an unequip-equip cycle, but does return `true`. If the item cannot be equipped, it will return `false`.
--- 
--- Equip may fail for the following reasons:
--- 
--- - The item cannot be found in the inventory.
--- - The exact match cannot be found when itemData is provided.
--- - When a weapon is being used to attack, it cannot be replaced.
--- 
--- !!! warning
--- 	This method doesn't trigger [equip](https://mwse.github.io/MWSE/events/equip/) or [equipped](https://mwse.github.io/MWSE/events/equipped/) events.
--- 
--- @param params tes3mobileActor.equip.params This table accepts the following values:
--- 
--- `item`: tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon|string — The item to equip.
--- 
--- `itemData?`: tes3itemData — *Optional*. The item data of the specific item to equip, if a specific item is required.
--- 
--- `addItem?`: boolean — *Default*: `false`. If `true`, the item will be added to the actor's inventory if needed.
--- 
--- `selectBestCondition?`: boolean — *Default*: `false`. If `true`, the item in the inventory with the best condition and best charge will be selected.
--- 
--- `selectWorstCondition?`: boolean — *Default*: `false`. If `true`, the item in the inventory with the worst condition and worst charge will be selected. Can be useful for selecting tools.
--- 
--- `playSound?`: boolean — *Default*: `true`. If `true`, the default item sound will be played for the item.
--- @return boolean itemEquipped No description yet available.
function tes3mobileActor:equip(params) end

---Table parameter definitions for `tes3mobileActor.equip`.
--- @class tes3mobileActor.equip.params
--- @field item tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon|string The item to equip.
--- @field itemData? tes3itemData *Optional*. The item data of the specific item to equip, if a specific item is required.
--- @field addItem? boolean *Default*: `false`. If `true`, the item will be added to the actor's inventory if needed.
--- @field selectBestCondition? boolean *Default*: `false`. If `true`, the item in the inventory with the best condition and best charge will be selected.
--- @field selectWorstCondition? boolean *Default*: `false`. If `true`, the item in the inventory with the worst condition and worst charge will be selected. Can be useful for selecting tools.
--- @field playSound? boolean *Default*: `true`. If `true`, the default item sound will be played for the item.

--- Equips a spell or enchantment, optionally equipping the enchanted item if needed. Returns `false` if the item could not be equipped.
--- @param params tes3mobileActor.equipMagic.params This table accepts the following values:
--- 
--- `source`: tes3spell|tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon|string — The source of the magic to equip.
--- --- 
--- --- 		Spells must be castable. Castable spells have a `castType` of `tes3.spellType.spell` or `tes3.spellType.power`. The actor is not required to know this spell.
--- --- 
--- --- 		Items must have a castable enchantment. Castable enchantments have a `castType` of `tes3.enchantmentType.onUse` or `tes3.enchantmentType.castOnce`. The actor is not required to have this item in their inventory, unless `equipItem` is `true`.
--- --- 
--- 
--- `itemData?`: tes3itemData — *Optional*. Only valid if an item has been assigned to `source`. The item data of the specific item to equip.
--- 
--- `equipItem?`: boolean — *Default*: `false`. Only valid if an item has been assigned to `source`. If `true`, the item assigned to `source` will be equipped. Requires the actor to have the item in their inventory. If `false`, `itemData` must not be nil.
--- 
--- `updateGUI?`: boolean — *Default*: `true`. Only valid if this actor is the player. If `false`, the player GUI will not be updated to reflect the change to equipped magic.
--- @return boolean result No description yet available.
function tes3mobileActor:equipMagic(params) end

---Table parameter definitions for `tes3mobileActor.equipMagic`.
--- @class tes3mobileActor.equipMagic.params
--- @field source tes3spell|tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon|string The source of the magic to equip.
--- 
--- 		Spells must be castable. Castable spells have a `castType` of `tes3.spellType.spell` or `tes3.spellType.power`. The actor is not required to know this spell.
--- 
--- 		Items must have a castable enchantment. Castable enchantments have a `castType` of `tes3.enchantmentType.onUse` or `tes3.enchantmentType.castOnce`. The actor is not required to have this item in their inventory, unless `equipItem` is `true`.
--- 
--- @field itemData? tes3itemData *Optional*. Only valid if an item has been assigned to `source`. The item data of the specific item to equip.
--- @field equipItem? boolean *Default*: `false`. Only valid if an item has been assigned to `source`. If `true`, the item assigned to `source` will be equipped. Requires the actor to have the item in their inventory. If `false`, `itemData` must not be nil.
--- @field updateGUI? boolean *Default*: `true`. Only valid if this actor is the player. If `false`, the player GUI will not be updated to reflect the change to equipped magic.

--- Causes the actor to perform a weapon swing immediately towards its current target. For the player, it will swing and release immediately (minimum damage), and also may hit any target in range.
--- 
--- The actor must be in combat, with its weapon or hands readied, to be able to swing its weapon. This function does not interrupt existing attacks, casting, or any other actions. It returns true if it was able to start the weapon swing.
--- @param params tes3mobileActor.forceWeaponAttack.params This table accepts the following values:
--- 
--- `attackType?`: tes3.physicalAttackType — *Optional*. The physical attack type to use for melee weapons (slash, chop, thrust). Maps to values in [`tes3.physicalAttackType`](https://mwse.github.io/MWSE/references/physical-attack-types/) namespace. When not specified, it uses a weighted random attack type for NPCs and creatures.
--- 
--- `swing?`: number — *Optional*. The strength of the attack swing, in the range [0 to 1]. When not specified, the attack swing is randomized. This value cannot affect the player swing, as player attacks are driven by input.
--- @return boolean result No description yet available.
function tes3mobileActor:forceWeaponAttack(params) end

---Table parameter definitions for `tes3mobileActor.forceWeaponAttack`.
--- @class tes3mobileActor.forceWeaponAttack.params
--- @field attackType? tes3.physicalAttackType *Optional*. The physical attack type to use for melee weapons (slash, chop, thrust). Maps to values in [`tes3.physicalAttackType`](https://mwse.github.io/MWSE/references/physical-attack-types/) namespace. When not specified, it uses a weighted random attack type for NPCs and creatures.
--- @field swing? number *Optional*. The strength of the attack swing, in the range [0 to 1]. When not specified, the attack swing is randomized. This value cannot affect the player swing, as player attacks are driven by input.

--- Fetches a filtered list of the active magic effects on the actor.
--- @param params? tes3mobileActor.getActiveMagicEffects.params This table accepts the following values:
--- 
--- `effect?`: tes3.effect|integer — *Optional*. The magic effect ID to search for, from [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- 
--- `serial?`: integer — *Optional*. The magic instance serial to search for.
--- @return tes3activeMagicEffect[] result No description yet available.
function tes3mobileActor:getActiveMagicEffects(params) end

---Table parameter definitions for `tes3mobileActor.getActiveMagicEffects`.
--- @class tes3mobileActor.getActiveMagicEffects.params
--- @field effect? tes3.effect|integer *Optional*. The magic effect ID to search for, from [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- @field serial? integer *Optional*. The magic instance serial to search for.

--- *Read-only*. Gets the weight of the boots equipped on the actor, or 0 if no boots are equipped.
--- @return number result No description yet available.
function tes3mobileActor:getBootsWeight() end

--- Returns the distance used for checking attack range. This is measured by the distance between the actors' bounding boxes edges, as if the actors were exactly facing each other. The number may be negative if the bounding boxes overlap.
--- @param mobile tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer The target actor.
--- @return number distance No description yet available.
function tes3mobileActor:getEffectiveAttackDistance(mobile) end

--- Gets the fatigue-based skill scaling term used by many game mechanics, based on the actor's current and maximum fatigue. It is equal to `max(0, fFatigueBase - fFatigueMult * max(0, 1 - fatigue.current/fatigue.base))`
--- @return number result No description yet available.
function tes3mobileActor:getFatigueTerm() end

--- Finds the timestamp a recharging power was used. Powers recharge 24 hours after this timestamp. The timestamp units are hours. The current time as a timestamp can be accessed at [`tes3.getSimulationTimestamp()`](https://mwse.github.io/MWSE/apis/tes3/#tes3getsimulationtimestamp).
--- @param power tes3spell The spell object for the power.
--- @return number timestamp No description yet available.
function tes3mobileActor:getPowerUseTimestamp(power) end

--- Fetches the statistic object of a skill with a given index. This is the way to access skills for any type of actor, as creatures have a limited version of the skill system. Note that creatures share a statistic between multiple skills (they only have combat, magic, and stealth stats), so many values will be the same.
--- @param skillId tes3.skill The index of the skill statistic to fetch. Maps to values in [`tes3.skill`](https://mwse.github.io/MWSE/references/skills/) namespace.
--- @return tes3statisticSkill result No description yet available.
function tes3mobileActor:getSkillStatistic(skillId) end

--- Fetches the current value of a skill with a given index. This is the way to access skills for any type of actor, as creatures have a limited version of the skill system. Note that creatures share a statistic between multiple skills (they only have combat, magic, and stealth stats), so many values will be the same.
--- @param skillId tes3.skill The index of the skill statistic's value to fetch. Maps to values in [`tes3.skill`](https://mwse.github.io/MWSE/references/skills/) namespace.
--- @return number result No description yet available.
function tes3mobileActor:getSkillValue(skillId) end

--- Returns the angle between provided actor and the front side of the actor on whom the method was called. The returned angle is in degress in range [-180, 180], where 0 degrees is directly in front of the actor, the negative values are on the actor's left side, and positive values on the actor's right.
--- @param mobile tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer The target actor to calculate the facing angle.
--- @return number angle In range of [-180, 180] in degrees.
function tes3mobileActor:getViewToActor(mobile) end

--- Returns the angle between provided point in space and the front side of the actor on whom the method was called. The returned angle is in degress in range [-180, 180], where 0 degrees is directly in front of the actor, the negative values are on the actor's left side, and positive values on the actor's right.
---
--- [Examples available in online documentation](https://mwse.github.io/MWSE/types/tes3mobileActor/#getviewtopoint).
--- @param point tes3vector3 The target point to calculate the facing angle.
--- @return number angle In range of [-180, 180] in degrees.
function tes3mobileActor:getViewToPoint(point) end

--- Returns the angle between provided point in space and the actor's current position with provided facing (which effectively overrides the actor's facing used in other getViewTo methods). The returned angle is in degress in range [-180, 180], where 0 degrees is directly in front of the provided facing angle with the origin in actor's position.
--- @param facing number The facing angle in radians. The values should be in [0, PI] interval.
--- @param point tes3vector3 The target point to calculate the facing angle.
--- @return number angle In range of [-180, 180] in degrees.
function tes3mobileActor:getViewToPointWithFacing(facing, point) end

--- Fetches the weapon speed of the actor's currently equipped weapon, or `1.0` if no weapon is equipped.
--- @return number result No description yet available.
function tes3mobileActor:getWeaponSpeed() end

--- Check if a power has been used and is recharging.
--- @param power tes3spell The spell object for the power.
--- @return boolean result No description yet available.
function tes3mobileActor:hasUsedPower(power) end

--- Induces hit stun on the actor. Without any parameters, it produces a brief stun that lasts about 1 second and prevents starting a new attack. It can produce other types of stun, see parameters. There are states where actors can't be stunned (such as already being in hit stun and paralysis). The function will return if the stun was successfuly applied.
--- @param params? tes3mobileActor.hitStun.params This table accepts the following values:
--- 
--- `knockDown?`: boolean — *Optional*. Changes the stun type to knockdown. This is when the character falls to their knees and takes several seconds to recover. It will interrupt spell casting.
--- 
--- `cancel?`: boolean — *Optional*. Cancels hit stun and knockdown when used on the same frame as the hit. For regular combat, it should be used in the events `damaged` or `damagedHandToHand`.
--- @return boolean result No description yet available.
function tes3mobileActor:hitStun(params) end

---Table parameter definitions for `tes3mobileActor.hitStun`.
--- @class tes3mobileActor.hitStun.params
--- @field knockDown? boolean *Optional*. Changes the stun type to knockdown. This is when the character falls to their knees and takes several seconds to recover. It will interrupt spell casting.
--- @field cancel? boolean *Optional*. Cancels hit stun and knockdown when used on the same frame as the hit. For regular combat, it should be used in the events `damaged` or `damagedHandToHand`.

--- Determines if the actor is currently being affected by a given alchemy, enchantment, or spell.
--- @param object tes3alchemy|tes3enchantment|tes3spell The magic to check for.
--- @return boolean result No description yet available.
function tes3mobileActor:isAffectedByObject(object) end

--- Kills the actor by setting its health to 0.
function tes3mobileActor:kill() end

--- 
--- !!! warning
--- 	This part of the API isn't fully understood yet and thus is considered experimental. That means that there can be breaking changes requiring the code using this part of the API to be rewritten. The MWSE team will not make any effort to keep backward compatibility with the mods using experimental APIs.
--- 
---  Causes the actor to look towards this reference, while obey the usual head turning constraints. This must be called every frame in the `simulate` event to work. It will override regular head look behaviour and the target may be at any distance in the same worldspace.
--- @param target tes3reference No description yet available.
function tes3mobileActor:overrideHeadTrackingThisFrame(target) end

--- Makes a power immediately available for casting again.
--- @param power tes3spell The spell object for the power.
--- @return boolean result No description yet available.
function tes3mobileActor:rechargePower(power) end

--- Resurrects the actor, with more control over the resurrect logic compared to mwscript.
--- @param params tes3mobileActor.resurrect.params This table accepts the following values:
--- 
--- `resetState?`: boolean — *Default*: `true`. Controls if the stats are reset, the inventory contents are respawned, and the reference recreated. This is the logic that mwscript resurrect uses. It can be useful to reset armor, ammunition, and consumables, if the player has already looted the body. When false, the base stats and inventory are unchanged.
--- 
--- `moveToStartingLocation?`: boolean — *Default*: `false`. Controls if the actor should be moved to its spawn point on resurrection. Requires `resetState` to be true.
function tes3mobileActor:resurrect(params) end

---Table parameter definitions for `tes3mobileActor.resurrect`.
--- @class tes3mobileActor.resurrect.params
--- @field resetState? boolean *Default*: `true`. Controls if the stats are reset, the inventory contents are respawned, and the reference recreated. This is the logic that mwscript resurrect uses. It can be useful to reset armor, ammunition, and consumables, if the player has already looted the body. When false, the base stats and inventory are unchanged.
--- @field moveToStartingLocation? boolean *Default*: `false`. Controls if the actor should be moved to its spawn point on resurrection. Requires `resetState` to be true.

--- Sets the timestamp a recharging power was used. Powers recharge 24 hours after this timestamp.
--- @param power tes3spell The spell object for the power.
--- @param timestamp number The timestamp of the moment the power was casted, or 24 hours before the recharge point. The timestamp units are hours. The current time as a timestamp can be accessed at [`tes3.getSimulationTimestamp()`](https://mwse.github.io/MWSE/apis/tes3/#tes3getsimulationtimestamp).
function tes3mobileActor:setPowerUseTimestamp(power, timestamp) end

--- Forces the actor into combat with another actor.
--- @param target tes3mobileActor|tes3mobileCreature|tes3mobileNPC|tes3mobilePlayer No description yet available.
function tes3mobileActor:startCombat(target) end

--- Starts dialogue with this actor for the player.
function tes3mobileActor:startDialogue() end

--- Ends combat for the actor.
--- @param force? boolean *Default*: `false`. If `false`, the function won't stop combat if the actor has other valid hostile targets.
function tes3mobileActor:stopCombat(force) end

--- Unequips one or more items from the actor.
--- 
--- !!! note
--- 	This method triggers the [unequipped](https://mwse.github.io/MWSE/events/unequipped/) event, unlike the `equip` method.
--- @param params tes3mobileActor.unequip.params This table accepts the following values:
--- 
--- `item?`: tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon|string — *Optional*. The item to unequip.
--- 
--- `itemData?`: tes3itemData — *Optional*. The item data of the specific item to unequip, if a specific item is required.
--- 
--- `type?`: tes3.objectType — *Optional*. The item type to unequip. Only used if no other parameter is provided. Only values pertaining to equipment from [`tes3.objectType`](https://mwse.github.io/MWSE/references/object-types/) can be passed here.
--- 
--- `armorSlot?`: tes3.armorSlot — *Optional*. The armor slot to unequip. Maps to values in [`tes3.armorSlot`](https://mwse.github.io/MWSE/references/armor-slots/) namespace.
--- 
--- `clothingSlot?`: tes3.clothingSlot — *Optional*. The clothing slot to unequip. Maps to values in [`tes3.clothingSlot`](https://mwse.github.io/MWSE/references/clothing-slots/) namespace
--- @return boolean itemUnequipped No description yet available.
function tes3mobileActor:unequip(params) end

---Table parameter definitions for `tes3mobileActor.unequip`.
--- @class tes3mobileActor.unequip.params
--- @field item? tes3alchemy|tes3apparatus|tes3armor|tes3book|tes3clothing|tes3ingredient|tes3item|tes3light|tes3lockpick|tes3misc|tes3probe|tes3repairTool|tes3weapon|string *Optional*. The item to unequip.
--- @field itemData? tes3itemData *Optional*. The item data of the specific item to unequip, if a specific item is required.
--- @field type? tes3.objectType *Optional*. The item type to unequip. Only used if no other parameter is provided. Only values pertaining to equipment from [`tes3.objectType`](https://mwse.github.io/MWSE/references/object-types/) can be passed here.
--- @field armorSlot? tes3.armorSlot *Optional*. The armor slot to unequip. Maps to values in [`tes3.armorSlot`](https://mwse.github.io/MWSE/references/armor-slots/) namespace.
--- @field clothingSlot? tes3.clothingSlot *Optional*. The clothing slot to unequip. Maps to values in [`tes3.clothingSlot`](https://mwse.github.io/MWSE/references/clothing-slots/) namespace

--- Unequips the currently equipped magic, optionally unequipping the enchanted item if needed.
--- @param params? tes3mobileActor.unequipMagic.params This table accepts the following values:
--- 
--- `unequipItem?`: boolean — *Default*: `false`. Only valid if the currently equipped magic is from an equippable item enchantment. If `true`, the item containing the enchantment will be unequipped.
--- 
--- `updateGUI?`: boolean — *Default*: `true`. Only valid if this actor is the player. If `false`, the player GUI will not be updated to reflect the change to equipped magic.
function tes3mobileActor:unequipMagic(params) end

---Table parameter definitions for `tes3mobileActor.unequipMagic`.
--- @class tes3mobileActor.unequipMagic.params
--- @field unequipItem? boolean *Default*: `false`. Only valid if the currently equipped magic is from an equippable item enchantment. If `true`, the item containing the enchantment will be unequipped.
--- @field updateGUI? boolean *Default*: `true`. Only valid if this actor is the player. If `false`, the player GUI will not be updated to reflect the change to equipped magic.

--- Updates statistics derived from attributes, which are magicka, fatigue, and encumbrance. Will also update the UI if used on the player. Normally handled automatically when you use `tes3.modStatistic()`.
--- @param attribute? tes3statistic|tes3statisticSkill *Optional*. Limits the update to statistics derived from this attribute.  e.g. `mobile:updateDerivedStatistics(mobile.strength)`. If not present, all derived statistics will be updated.
function tes3mobileActor:updateDerivedStatistics(attribute) end

--- Updates the actor's visual opacity. Used after modifying applied chameleon or invisiblity effects.
function tes3mobileActor:updateOpacity() end

